﻿using System;
using System.Linq;
using System.Text;
using System.IO;
using System.Web.UI.WebControls;
using System.Xml;
using System.Xml.Xsl;
using HIPS.PcehrSchemas;

namespace HIPS.Web.UI.Helpers
{

    /// <summary>
    /// Extension methods to assist with the PCEHR View feature.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="21 November 2013">Initial version.</change>
    /// </history>
    public static class PcehrViewExtensions
    {
        

        #region Methods

        public static string TransformToHtml(this DocumentResponse doc, string stylesheetContent)
        {
            // Load Xml Document
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.PreserveWhitespace = true;
            using (MemoryStream ms = new MemoryStream(doc.Document))
            {
                xmlDoc.Load(ms);
            }

            // Load stylesheet
            var stylesheet = new XslCompiledTransform();
            XmlDocument styleDoc = new XmlDocument();
            styleDoc.PreserveWhitespace = true;
            styleDoc.LoadXml(stylesheetContent);

            // Stylesheet additions

            string cssAdditions = @"
                img { max-width:100% !important; max-height: 600px !important; } /* Stops wide images breaking outside document frame */
                .spaceToScrollToFootnotesDiv { display: none !important; } /* Unnecessary additional footer space */
            ";
            
            // Add CSS
            var cssHeadMediaAll = styleDoc.SelectSingleNode("//*[local-name()='template' and @name='addCSS']/*[local-name()='element' and @name='style'][1]");
            cssHeadMediaAll.AppendChild(styleDoc.CreateTextNode(cssAdditions));

            // Complete stylesheet load with additions
            stylesheet.Load(styleDoc);

            // Apply stylesheet
            StringBuilder sb = new StringBuilder();
            using (StringWriter writer = new StringWriter(sb))
            {
                stylesheet.Transform(xmlDoc, null, writer);
            }

            return sb.ToString();
        }
        
        public static string TransformToHtml(this ViewResponse view, string stylesheetContent, string documentViewUrlRoot, string patientId, DateTime fromDate, DateTime toDate, string groupBy)
        {
            // TODO: Unify some logic with DocumentResponse SaveAndTransform

            // Load Xml Document
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.PreserveWhitespace = true;
            using (MemoryStream ms = new MemoryStream(view.Document))
            {
                xmlDoc.Load(ms);
            }

            // Load stylesheet
            var stylesheet = new XslCompiledTransform();
            stylesheet.Load(XmlReader.Create(new StringReader(stylesheetContent)));

            // Parameters
            XsltArgumentList arguments = new XsltArgumentList();
            arguments.AddParam("addJavaScript", String.Empty, "false"); // Disabled due to iframe rendering issues
            arguments.AddParam("collapsedGroups", String.Empty, "false"); // Enabled to support replacement javascript
            arguments.AddParam("groupBy", String.Empty, groupBy);

            // Apply stylesheet
            StringBuilder sb = new StringBuilder();
            using (StringWriter writer = new StringWriter(sb))
            {
                stylesheet.Transform(xmlDoc, arguments, writer);
            }

            // Rewrite document URLs
            // Replace 'href="pcehr:' with 'target="_top" href="documentViewUrlRoot'
            string content = sb.ToString().Replace("href=\"pcehr:", String.Format(@"target=""_blank"" href=""{0}", documentViewUrlRoot));

            return content;
        }

        #endregion

    }
}